/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.data.concordance;

import edu.mit.jmwe.data.concordance.ConcordanceToken;
import edu.mit.jmwe.util.AbstractFileSelector;
import edu.mit.jmwe.util.IProgressBar;
import edu.mit.jmwe.util.JWIPOS;
import edu.mit.jmwe.util.NullProgressBar;
import edu.mit.jmwe.util.ProgressBar;
import edu.mit.jmwe.util.StreamAdapter;
import edu.mit.jsemcor.element.IContext;
import edu.mit.jsemcor.element.IContextID;
import edu.mit.jsemcor.element.ISentence;
import edu.mit.jsemcor.element.IToken;
import edu.mit.jsemcor.element.IWordform;
import edu.mit.jsemcor.main.IConcordance;
import edu.mit.jsemcor.main.IConcordanceSet;
import edu.mit.jsemcor.main.Semcor;
import edu.mit.jwi.Dictionary;
import edu.mit.jwi.IDictionary;
import edu.mit.jwi.item.POS;
import edu.mit.jwi.morph.IStemmer;
import edu.mit.jwi.morph.WordnetStemmer;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.SentenceProcessor;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.process.PTBTokenizer;
import edu.stanford.nlp.tagger.maxent.MaxentTagger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcordanceTagger
extends AbstractFileSelector
implements Runnable {
    public static void main(String[] args) {
        ConcordanceTagger tagger = new ConcordanceTagger();
        tagger.run();
    }

    @Override
    public void run() {
        Writer writer;
        SentenceProcessor<HasWord, ? extends TaggedWord> posTagger;
        IConcordanceSet semcor = this.getSemcor();
        if (semcor == null) {
            return;
        }
        IStemmer stemmer = this.getStemmer();
        if (stemmer == null) {
            return;
        }
        try {
            posTagger = this.getPOSTagger();
            if (posTagger == null) {
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        try {
            writer = this.getWriter();
            if (writer == null) {
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        int num = 0;
        for (IConcordance c : semcor.values()) {
            num += c.getContextIDs().size();
        }
        ProgressBar pb = new ProgressBar(num);
        try {
            this.process(semcor.values(), posTagger, stemmer, writer, pb);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected IConcordanceSet getSemcor() {
        File dir = this.chooseDirectory("Select Semcor Directory", IConcordanceSet.class);
        if (dir == null) {
            return null;
        }
        Semcor semcor = new Semcor(StreamAdapter.toURL(dir));
        if (!semcor.open()) {
            throw new IllegalStateException("Unable to open Semcor");
        }
        return semcor;
    }

    protected IStemmer getStemmer() {
        File dir = this.chooseDirectory("Select Wordnet Directory", IDictionary.class);
        if (dir == null) {
            return null;
        }
        Dictionary wordnet = new Dictionary(StreamAdapter.toURL(dir));
        if (!wordnet.open()) {
            throw new IllegalStateException("Unable to open Wordnet");
        }
        return new WordnetStemmer((IDictionary)wordnet);
    }

    protected SentenceProcessor<HasWord, ? extends TaggedWord> getPOSTagger() throws Exception {
        File file = this.chooseFile("Select StanfordNLP Tagging Model", SentenceProcessor.class);
        if (file == null) {
            return null;
        }
        return new MaxentTagger(file.getAbsolutePath());
    }

    protected Writer getWriter() throws IOException {
        File file = this.chooseFileForWriting("Select Output File", Writer.class);
        if (file == null) {
            return null;
        }
        this.setLocation(Writer.class, file);
        return new BufferedWriter(new FileWriter(file));
    }

    @Override
    protected File getLocation(Class<?> key) {
        Preferences node = Preferences.userNodeForPackage(ConcordanceTagger.class);
        String path = node.get(key.getCanonicalName(), null);
        return path == null ? null : new File(path);
    }

    @Override
    protected void setLocation(Class<?> key, File loc) {
        Preferences node = Preferences.userNodeForPackage(ConcordanceTagger.class);
        node.put(key.getCanonicalName(), loc.getAbsolutePath());
    }

    public void process(Iterable<? extends IConcordance> cs, SentenceProcessor<HasWord, ? extends TaggedWord> posTagger, IStemmer stemmer, Writer writer, IProgressBar pb) throws IOException {
        this.process(null, -1, cs, posTagger, stemmer, writer, pb);
    }

    public void process(IContextID startContext, int startSent, Iterable<? extends IConcordance> cs, SentenceProcessor<HasWord, ? extends TaggedWord> posTagger, IStemmer stemmer, Writer writer, IProgressBar pb) throws IOException {
        if (cs == null) {
            throw new NullPointerException();
        }
        if (writer == null) {
            throw new NullPointerException();
        }
        if (pb == null) {
            pb = NullProgressBar.getInstance();
        }
        if (startContext != null) {
            System.out.println("Starting at context " + startContext.toString());
        }
        if (startSent > 0) {
            System.out.println("Starting at sentence " + startSent);
        }
        Iterator<? extends IConcordance> concordItr = cs.iterator();
        while (concordItr.hasNext()) {
            IConcordance concord = concordItr.next();
            Iterator contextItr = concord.iterator();
            while (contextItr.hasNext()) {
                IContext context = (IContext)contextItr.next();
                if (startContext != null) {
                    if (!context.getID().equals(startContext)) continue;
                    startContext = null;
                }
                Iterator sentItr = context.getSentences().iterator();
                while (sentItr.hasNext()) {
                    ISentence sent = (ISentence)sentItr.next();
                    if (startSent > 0) {
                        if (sent.getNumber() <= startSent) continue;
                        startSent = -1;
                    }
                    this.process(context.getID(), sent, posTagger, stemmer, writer);
                    if (!sentItr.hasNext()) continue;
                    writer.append('\n');
                }
                if (contextItr.hasNext()) {
                    writer.append('\n');
                }
                pb.increment();
            }
            if (!concordItr.hasNext()) continue;
            writer.append('\n');
        }
        pb.finish();
    }

    protected void process(IContextID cid, ISentence s, SentenceProcessor<HasWord, ? extends TaggedWord> posTagger, IStemmer stemmer, Writer writer) throws IOException {
        ArrayList<HasWord> input = this.makeSentence(s, stemmer);
        ArrayList output = posTagger.processSentence(input);
        writer.append(cid.getConcordanceName());
        writer.append('/');
        writer.append(cid.getContextName());
        writer.append('/');
        writer.append(Integer.toString(s.getNumber()));
        writer.append(' ');
        for (int i = 0; i < input.size(); ++i) {
            TaggerToken token = (TaggerToken)input.get(i);
            token.setTag(((TaggedWord)output.get(i)).tag());
            writer.append(ConcordanceToken.toString(token));
            if (i >= input.size()) continue;
            writer.append(' ');
        }
    }

    protected ArrayList<HasWord> makeSentence(ISentence s, IStemmer stemmer) {
        LinkedList<TaggerToken> result = new LinkedList<TaggerToken>();
        for (int i = 0; i < s.size(); ++i) {
            IToken token = (IToken)s.get(i);
            if (token instanceof IWordform) {
                this.addWords((IWordform)token, i, result, stemmer);
                continue;
            }
            result.add(new TaggerToken(token.getText(), i, 0, null));
        }
        return new ArrayList<HasWord>(result);
    }

    protected void addWords(IWordform wf, int tokenNum, List<TaggerToken> result, IStemmer stemmer) {
        List tokens = wf.getConstituentTokens();
        for (int i = 0; i < tokens.size(); ++i) {
            String token = (String)tokens.get(i);
            List<String> stems = this.stem(token, wf, stemmer);
            result.add(new TaggerToken((String)tokens.get(i), tokenNum, i, stems));
        }
    }

    protected List<String> stem(String token, IWordform wf, IStemmer stemmer) {
        POS pos = JWIPOS.toPOS(wf.getPOSTag());
        boolean shouldStem = wf.getConstituentTokens().size() > 1 || pos != null;
        List stems = null;
        if (shouldStem) {
            stems = stemmer.findStems(token, pos);
            Iterator itr = stems.iterator();
            while (itr.hasNext()) {
                if (((String)itr.next()).trim().length() != 0) continue;
                itr.remove();
            }
        }
        return stems;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TaggerToken
    extends ConcordanceToken
    implements HasWord {
        private final String word;
        private String tag;

        public TaggerToken(String surfaceText, int tokenNum, int partNum, List<String> stems) {
            super(surfaceText, null, tokenNum, partNum, stems == null ? new String[]{} : stems.toArray(new String[stems.size()]));
            PTBTokenizer tok = PTBTokenizer.newPTBTokenizer((Reader)new StringReader(surfaceText));
            List tokens = tok.tokenize();
            this.word = tokens.size() == 1 ? ((Word)tokens.get(0)).word() : surfaceText;
        }

        public String word() {
            return this.word;
        }

        public void setWord(String word) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTag() {
            return this.tag;
        }

        public void setTag(String tag) {
            this.tag = tag;
        }
    }
}

