/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.data.concordance;

import edu.mit.jmwe.data.concordance.ConcordanceToken;
import edu.mit.jmwe.data.concordance.IConcordanceSentence;
import edu.mit.jmwe.data.concordance.IConcordanceToken;
import edu.mit.jsemcor.element.ContextID;
import edu.mit.jsemcor.element.IContextID;
import edu.mit.jsemcor.element.ISentence;
import edu.mit.jsemcor.element.IToken;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.RandomAccess;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcordanceSentence
extends AbstractList<IConcordanceToken>
implements IConcordanceSentence,
RandomAccess {
    private final String id;
    private final IContextID cid;
    private final int sentNum;
    private final List<? extends IConcordanceToken> backingList;
    private transient String toString;
    public static final Pattern taggedSemcorSentencePattern = Pattern.compile("^\\s*(\\S+)/(\\S+)/(\\d+)\\s+(\\S.*)$");

    public ConcordanceSentence(IContextID cid, ISentence sent) {
        if (cid == null) {
            throw new NullPointerException();
        }
        if (sent == null) {
            throw new NullPointerException();
        }
        LinkedList<ConcordanceToken> tokens = new LinkedList<ConcordanceToken>();
        for (int i = 0; i < sent.size(); ++i) {
            tokens.addAll(ConcordanceToken.toTokens((IToken)sent.get(i), i, sent));
        }
        this.id = ConcordanceSentence.makeID(cid, sent.getNumber());
        this.backingList = Collections.unmodifiableList(new ArrayList(tokens));
        this.cid = cid;
        this.sentNum = sent.getNumber();
    }

    public ConcordanceSentence(IContextID cid, int sentNum, List<? extends IConcordanceToken> tokens) {
        if (cid == null) {
            throw new NullPointerException();
        }
        for (IConcordanceToken iConcordanceToken : tokens) {
            if (iConcordanceToken != null) continue;
            throw new NullPointerException();
        }
        if (sentNum < 1) {
            throw new IllegalArgumentException();
        }
        if (tokens.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.id = ConcordanceSentence.makeID(cid, sentNum);
        this.cid = cid;
        this.sentNum = sentNum;
        this.backingList = new ArrayList<IConcordanceToken>(tokens);
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public IContextID getContextID() {
        return this.cid;
    }

    @Override
    public int getSentenceNumber() {
        return this.sentNum;
    }

    @Override
    public IConcordanceToken get(int index) {
        return this.backingList.get(index);
    }

    @Override
    public int size() {
        return this.backingList.size();
    }

    @Override
    public String toString() {
        if (this.toString == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.id);
            sb.append(' ');
            Iterator<? extends IConcordanceToken> i = this.backingList.iterator();
            while (i.hasNext()) {
                sb.append(i.next());
                if (!i.hasNext()) continue;
                sb.append(' ');
            }
            this.toString = sb.toString();
        }
        return this.toString;
    }

    public static ConcordanceSentence parse(String toString) {
        try {
            Matcher matcher = taggedSemcorSentencePattern.matcher(toString);
            if (!matcher.matches()) {
                throw new IllegalArgumentException();
            }
            ContextID cid = new ContextID(matcher.group(2), matcher.group(1));
            int sentNum = Integer.parseInt(matcher.group(3));
            List<ConcordanceToken> tokens = ConcordanceToken.parseList(matcher.group(4));
            return new ConcordanceSentence((IContextID)cid, sentNum, tokens);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Exception parsing semcor sentence: " + toString, t);
        }
    }

    public static String makeID(IContextID cid, int sentNum) {
        StringBuilder id = new StringBuilder();
        id.append(cid.getConcordanceName());
        id.append("/");
        id.append(cid.getContextName());
        id.append("/");
        id.append(sentNum);
        return id.toString();
    }
}

