/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.data;

import edu.mit.jmwe.data.IToken;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Token
implements IToken {
    private final String tag;
    private final String text;
    private final List<String> stems;

    public Token(String text, String tag) {
        this(text, tag, null);
    }

    public Token(String text, String tag, String ... stems) {
        text = Token.checkString(text);
        List<String> stemList = Token.checkStems(stems);
        this.text = text;
        this.tag = tag;
        this.stems = stemList;
    }

    @Override
    public String getForm() {
        return this.text;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public List<String> getStems() {
        return this.stems;
    }

    public String toString() {
        return this.text + "_" + this.tag;
    }

    public static String checkString(String text) {
        if (text == null) {
            throw new NullPointerException();
        }
        if ((text = text.trim()).length() == 0) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (Character.isWhitespace(c)) {
                throw new IllegalArgumentException("Whitespace found in text '" + text + "'");
            }
            if (c != '_') continue;
            throw new IllegalArgumentException("Underscore found in text '" + text + "'");
        }
        return text;
    }

    public static List<String> checkStems(String[] stems) {
        if (stems == null) {
            return null;
        }
        if (stems.length == 0) {
            return Collections.emptyList();
        }
        for (int i = 0; i < stems.length; ++i) {
            if (stems[i] == null) {
                throw new NullPointerException("null stem at index " + i);
            }
            stems[i] = Token.checkString(stems[i]).toLowerCase();
        }
        return Collections.unmodifiableList(Arrays.asList(stems));
    }
}

