/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.data;

import edu.mit.jmwe.data.AbstractMWEDesc;
import edu.mit.jmwe.data.IInfMWEDesc;
import edu.mit.jmwe.data.IMWEDescID;
import edu.mit.jmwe.data.IRootMWEDesc;
import edu.mit.jmwe.data.InfMWEDesc;
import edu.mit.jmwe.data.MWEDescID;
import edu.mit.jmwe.data.MWEPOS;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootMWEDesc
extends AbstractMWEDesc<IRootMWEDesc.IRootPart>
implements IRootMWEDesc {
    private final IMWEDescID id;
    private final Map<String, IInfMWEDesc> inflected;

    public RootMWEDesc(String surfaceForm, MWEPOS pos) {
        this(RootMWEDesc.splitOnUnderscores(surfaceForm), pos, (Collection<? extends InfMWEDesc.InfMWEDescBuilder>)null, null);
    }

    public RootMWEDesc(String surfaceForm, MWEPOS pos, Collection<? extends InfMWEDesc.InfMWEDescBuilder> inflectedForms, int ... counts) {
        this(RootMWEDesc.splitOnUnderscores(surfaceForm), pos, inflectedForms, counts);
    }

    public RootMWEDesc(List<String> parts, MWEPOS pos) {
        this(parts, pos, (Collection<? extends InfMWEDesc.InfMWEDescBuilder>)null, null);
    }

    public RootMWEDesc(List<String> parts, MWEPOS pos, Collection<? extends InfMWEDesc.InfMWEDescBuilder> inflectedForms, int ... counts) {
        super(parts, counts);
        Map<String, InfMWEDesc> inflected;
        this.id = new MWEDescID(this.getForm(), pos);
        if (inflectedForms == null || inflectedForms.size() == 0) {
            inflected = Collections.emptyMap();
        } else {
            inflected = new TreeMap();
            for (InfMWEDesc.InfMWEDescBuilder infMWEDescBuilder : inflectedForms) {
                InfMWEDesc infDesc = infMWEDescBuilder.toInfMWEDesc(this);
                inflected.put(infDesc.getForm(), infDesc);
            }
        }
        this.inflected = Collections.unmodifiableMap(inflected);
    }

    @Override
    protected int getExpectedCountLength() {
        return 5;
    }

    @Override
    protected IRootMWEDesc.IRootPart makePart(String form, int index) {
        return new Part(form, index);
    }

    @Override
    public IMWEDescID getID() {
        return this.id;
    }

    @Override
    public MWEPOS getPOS() {
        return this.id.getPOS();
    }

    @Override
    public Map<String, ? extends IInfMWEDesc> getInflected() {
        return this.inflected;
    }

    @Override
    public int getUnmarkedInflected() {
        return this.counts[4];
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RootMWEDesc other = (RootMWEDesc)obj;
        return this.id.equals(other.id);
    }

    public static String toString(IRootMWEDesc mweDesc) {
        StringBuilder buf = new StringBuilder();
        try {
            RootMWEDesc.toString(mweDesc, (Appendable)buf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return buf.toString();
    }

    public static void toString(IRootMWEDesc root, Appendable buf) throws IOException {
        MWEDescID.toString(root.getID(), buf);
        buf.append(' ');
        RootMWEDesc.toString(root.getCounts(), buf);
        for (IInfMWEDesc iInfMWEDesc : root.getInflected().values()) {
            buf.append(' ');
            buf.append(iInfMWEDesc.getForm());
            buf.append(' ');
            RootMWEDesc.toString(iInfMWEDesc.getCounts(), buf);
        }
    }

    public static void toString(int[] counts, Appendable buf) throws IOException {
        int last = counts.length - 1;
        for (int i = 0; i < counts.length; ++i) {
            buf.append(Integer.toString(counts[i]));
            if (i >= last) continue;
            buf.append(',');
        }
    }

    public static IRootMWEDesc parse(String descStr) {
        try {
            StringTokenizer tokens = new StringTokenizer(descStr);
            String rootForm = tokens.nextToken();
            MWEPOS pos = MWEPOS.fromChar(rootForm.charAt(rootForm.length() - 1));
            rootForm = rootForm.substring(0, rootForm.length() - 2);
            int[] rootCounts = tokens.hasMoreTokens() ? RootMWEDesc.parseCounts(tokens.nextToken()) : null;
            LinkedList<InfMWEDesc.InfMWEDescBuilder> infForms = new LinkedList<InfMWEDesc.InfMWEDescBuilder>();
            while (tokens.hasMoreTokens()) {
                InfMWEDesc.InfMWEDescBuilder b = new InfMWEDesc.InfMWEDescBuilder();
                b.form = tokens.nextToken();
                b.counts = RootMWEDesc.parseCounts(tokens.nextToken());
                infForms.add(b);
            }
            return new RootMWEDesc(rootForm, pos, infForms, rootCounts);
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to parse line: " + descStr, t);
        }
    }

    public static int[] parseCounts(String countStr) {
        String[] countStrs = comma.split(countStr);
        int[] counts = new int[countStrs.length];
        for (int i = 0; i < countStrs.length; ++i) {
            counts[i] = Integer.parseInt(countStrs[i]);
        }
        return counts;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Part
    extends AbstractMWEDesc.AbstractPart
    implements IRootMWEDesc.IRootPart {
        public Part(String form, int index) {
            super(form, index);
        }

        @Override
        public IRootMWEDesc getParent() {
            return (IRootMWEDesc)super.getParent();
        }
    }
}

