/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.data;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MWEPOS {
    ADJECTIVE('J', "JJ"),
    NOUN('N', "NN"),
    OTHER('O', null),
    PROPER_NOUN('P', "NNP"),
    ADVERB('R', "RB", "WRB"),
    VERB('V', "VB");

    private final char identifier;
    private final Set<String> prefixes;
    private static Map<Character, MWEPOS> charMap;
    private static SortedMap<String, MWEPOS> prefixMap;

    private MWEPOS(char identifier, String ... prefixes) {
        Set<Object> pfxs;
        if (prefixes == null) {
            pfxs = Collections.emptySet();
        } else {
            for (int i = 0; i < prefixes.length; ++i) {
                prefixes[i] = prefixes[i].trim();
                for (int j = 0; j < prefixes[i].length(); ++j) {
                    if (!Character.isWhitespace(prefixes[i].charAt(j))) continue;
                    throw new IllegalArgumentException();
                }
            }
            pfxs = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(prefixes)));
        }
        this.identifier = identifier;
        this.prefixes = pfxs;
    }

    public char getIdentifier() {
        return this.identifier;
    }

    public Set<String> getPrefixes() {
        return this.prefixes;
    }

    public static MWEPOS fromChar(char identifier) {
        return charMap.get(Character.valueOf(identifier));
    }

    public static MWEPOS toMWEPOS(String tag) {
        if (tag == null) {
            throw new NullPointerException();
        }
        if ((tag = tag.trim()).length() == 0) {
            throw new IllegalArgumentException();
        }
        for (Map.Entry<String, MWEPOS> entry : prefixMap.entrySet()) {
            if (!tag.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return OTHER;
    }

    static {
        charMap = new HashMap<Character, MWEPOS>(MWEPOS.values().length);
        for (MWEPOS pos : MWEPOS.values()) {
            charMap.put(Character.valueOf(pos.getIdentifier()), pos);
        }
        prefixMap = new TreeMap(Collections.reverseOrder());
        for (MWEPOS pos : MWEPOS.values()) {
            for (String prefix : pos.getPrefixes()) {
                prefixMap.put(prefix, pos);
            }
        }
    }
}

