/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.data;

import edu.mit.jmwe.data.IMWEDescID;
import edu.mit.jmwe.data.MWEPOS;
import java.io.IOException;

public class MWEDescID
implements IMWEDescID {
    private final MWEPOS pos;
    private final String rootForm;
    private final String infForm;
    private final IMWEDescID rootID;
    private transient String toString;

    public MWEDescID(String rootForm, MWEPOS pos) {
        if (pos == null) {
            throw new NullPointerException();
        }
        if (!formPattern.matcher(rootForm = rootForm.trim().toLowerCase()).matches()) {
            throw new IllegalArgumentException("Illegal root form: " + rootForm);
        }
        this.rootForm = rootForm;
        this.pos = pos;
        this.infForm = null;
        this.rootID = this;
    }

    public MWEDescID(IMWEDescID rootID, String infForm) {
        if (rootID == null) {
            throw new NullPointerException();
        }
        if (!formPattern.matcher(infForm).matches()) {
            throw new IllegalArgumentException("Illegal inflected form: " + infForm);
        }
        this.rootID = rootID;
        this.rootForm = rootID.getForm();
        this.pos = rootID.getPOS();
        this.infForm = infForm;
    }

    public IMWEDescID getRootID() {
        return this.rootID;
    }

    public String getForm() {
        return this.rootForm;
    }

    public String getInflectedForm() {
        return this.infForm;
    }

    public MWEPOS getPOS() {
        return this.pos;
    }

    public int compareTo(IMWEDescID id) {
        int cmp = this.rootForm.compareTo(id.getForm());
        if (cmp != 0) {
            return cmp;
        }
        return this.pos.compareTo(id.getPOS());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.rootForm.hashCode();
        result = 31 * result + this.pos.hashCode();
        result = 31 * result + (this.infForm == null ? 0 : this.infForm.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MWEDescID other = (MWEDescID)obj;
        if (this.pos != other.pos) {
            return false;
        }
        if (this.infForm == null ? other.infForm != null : !this.infForm.equals(other.infForm)) {
            return false;
        }
        return this.rootForm.equals(other.rootForm);
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = MWEDescID.toString(this);
        }
        return this.toString;
    }

    public static String toString(IMWEDescID id) {
        StringBuilder sb = new StringBuilder(id.getForm().length() + 2);
        try {
            MWEDescID.toString(id, sb);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sb.toString();
    }

    public static void toString(IMWEDescID id, Appendable buf) throws IOException {
        buf.append(id.getForm());
        buf.append('_');
        buf.append(id.getPOS().getIdentifier());
        if (id.getInflectedForm() != null) {
            buf.append('/');
            buf.append(id.getInflectedForm());
        }
    }
}

