/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.data;

import edu.mit.jmwe.data.IMWE;
import edu.mit.jmwe.data.IToken;
import edu.mit.jmwe.util.AbstractIndexComparator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MWEComparator<T extends IToken>
extends AbstractIndexComparator<T, IMWE<T>> {
    public MWEComparator(List<T> list) {
        super(list);
    }

    public MWEComparator(Map<T, Integer> indexMap) {
        super(indexMap);
    }

    @Override
    public int compare(IMWE<T> one, IMWE<T> two) {
        if (one == two) {
            return 0;
        }
        if (one.getTokens().equals(two.getTokens())) {
            return one.getEntry().getPOS().compareTo(two.getEntry().getPOS());
        }
        return this.earlier(one, two) ? -1 : 1;
    }

    protected boolean earlier(IMWE<T> one, IMWE<T> two) {
        for (int n = 0; n < one.getTokens().size(); ++n) {
            IToken token1 = (IToken)one.getTokens().get(n);
            if (n < two.getTokens().size()) {
                IToken token2 = (IToken)two.getTokens().get(n);
                if (token2 == token1) continue;
                return (Integer)this.indexMap.get(token1) < (Integer)this.indexMap.get(token2);
            }
            return true;
        }
        return false;
    }
}

