/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.data;

import edu.mit.jmwe.data.AbstractMWEDesc;
import edu.mit.jmwe.data.IMWE;
import edu.mit.jmwe.data.IMWEDesc;
import edu.mit.jmwe.data.IToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MWE<T extends IToken>
implements IMWE<T> {
    private final IMWEDesc entry;
    private final String form;
    private final List<T> tokens;
    private final boolean isInflected;
    private final Map<T, IMWEDesc.IPart> partMap;

    public MWE(Map<T, IMWEDesc.IPart> partMap) {
        this(partMap, true);
    }

    public MWE(Map<T, IMWEDesc.IPart> partMap, boolean reallocate) {
        if (partMap == null) {
            throw new NullPointerException();
        }
        if (partMap.isEmpty()) {
            throw new IllegalArgumentException();
        }
        StringBuilder form = new StringBuilder();
        IMWEDesc entry = null;
        boolean isInflected = false;
        Iterator<Map.Entry<T, IMWEDesc.IPart>> i = partMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<T, IMWEDesc.IPart> e = i.next();
            if (e.getKey() == null) {
                throw new NullPointerException();
            }
            if (e.getValue() == null) {
                throw new NullPointerException();
            }
            if (entry == null) {
                entry = e.getValue().getParent();
            } else if (e.getValue().getParent() != entry) {
                throw new IllegalArgumentException();
            }
            isInflected |= !((IToken)e.getKey()).getForm().equalsIgnoreCase(e.getValue().getForm());
            form.append(((IToken)e.getKey()).getForm().toLowerCase());
            if (!i.hasNext()) continue;
            form.append('_');
        }
        if (entry == null) {
            throw new NullPointerException();
        }
        final LinkedHashMap map = partMap = reallocate ? new LinkedHashMap(partMap) : partMap;
        ArrayList ts = new ArrayList(partMap.keySet());
        Collections.sort(ts, new Comparator<T>(){

            @Override
            public int compare(T one, T two) {
                IMWEDesc.IPart pOne = (IMWEDesc.IPart)map.get(one);
                IMWEDesc.IPart pTwo = (IMWEDesc.IPart)map.get(two);
                return pOne.compareTo(pTwo);
            }
        });
        this.entry = entry;
        this.form = form.toString();
        this.isInflected = isInflected;
        this.tokens = Collections.unmodifiableList(ts);
        this.partMap = Collections.unmodifiableMap(partMap);
    }

    @Override
    public String getForm() {
        return this.form;
    }

    @Override
    public IMWEDesc getEntry() {
        return this.entry;
    }

    @Override
    public List<T> getTokens() {
        return this.tokens;
    }

    @Override
    public Map<T, IMWEDesc.IPart> getPartMap() {
        return this.partMap;
    }

    @Override
    public boolean isInflected() {
        return this.isInflected;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.entry.getID().toString());
        buf.append("={");
        Iterator<T> i = this.partMap.keySet().iterator();
        while (i.hasNext()) {
            buf.append(i.next());
            if (!i.hasNext()) continue;
            buf.append(',');
        }
        buf.append('}');
        return buf.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.entry.hashCode();
        result = 31 * result + this.partMap.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        MWE other = (MWE)obj;
        if (!this.entry.equals(other.getEntry())) {
            return false;
        }
        return this.partMap.equals(other.partMap);
    }

    public static boolean equals(IMWE<?> one, IMWE<?> two) {
        if (one == two) {
            return true;
        }
        if (one != null && two == null) {
            return false;
        }
        if (two != null && one == null) {
            return false;
        }
        if (one.equals(two)) {
            return true;
        }
        if (!one.getPartMap().keySet().equals(two.getPartMap().keySet())) {
            return false;
        }
        return AbstractMWEDesc.equalsRoots(one.getEntry(), two.getEntry());
    }

    public static double overlap(IMWE<?> one, IMWE<?> two) {
        int maxSize = one.getTokens().size() + two.getTokens().size();
        IdentityHashMap tokens = new IdentityHashMap(maxSize);
        for (Object token : one.getTokens()) {
            tokens.put(token, null);
        }
        for (Object token : two.getTokens()) {
            tokens.put(token, null);
        }
        double total = tokens.size();
        tokens.clear();
        for (Object token : one.getTokens()) {
            tokens.put(token, null);
        }
        tokens.keySet().retainAll(two.getTokens());
        double overlap = tokens.size();
        return overlap / total;
    }
}

