/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.data;

import edu.mit.jmwe.data.AbstractMWEDesc;
import edu.mit.jmwe.data.IInfMWEDesc;
import edu.mit.jmwe.data.IMWEDescID;
import edu.mit.jmwe.data.IRootMWEDesc;
import edu.mit.jmwe.data.MWEDescID;
import edu.mit.jmwe.data.MWEPOS;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfMWEDesc
extends AbstractMWEDesc<IInfMWEDesc.IInfPart>
implements IInfMWEDesc {
    private final IRootMWEDesc root;
    private final IMWEDescID id;

    public InfMWEDesc(IRootMWEDesc root, String inflectedForm) {
        this(root, InfMWEDesc.splitOnUnderscores(inflectedForm), null);
    }

    public InfMWEDesc(IRootMWEDesc root, String inflectedForm, int ... counts) {
        this(root, InfMWEDesc.splitOnUnderscores(inflectedForm), counts);
    }

    public InfMWEDesc(IRootMWEDesc root, List<String> parts) {
        this(root, parts, null);
    }

    public InfMWEDesc(IRootMWEDesc root, List<String> parts, int ... counts) {
        super(parts, counts);
        if (root == null) {
            throw new NullPointerException();
        }
        this.id = new MWEDescID(root.getID(), this.getForm());
        this.root = root;
    }

    @Override
    protected int getExpectedCountLength() {
        return 5;
    }

    @Override
    public IMWEDescID getID() {
        return this.id;
    }

    @Override
    public MWEPOS getPOS() {
        return this.id.getPOS();
    }

    @Override
    public IRootMWEDesc getRootMWEDesc() {
        return this.root;
    }

    @Override
    public int getMarkedPattern() {
        return this.counts[4];
    }

    @Override
    protected IInfMWEDesc.IInfPart makePart(String form, int index) {
        return new InfPart(form, index);
    }

    public static class InfMWEDescBuilder {
        public String form = null;
        public int[] counts = new int[5];

        public InfMWEDesc toInfMWEDesc(IRootMWEDesc root) {
            return new InfMWEDesc(root, this.form, this.counts);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class InfPart
    extends AbstractMWEDesc.AbstractPart
    implements IInfMWEDesc.IInfPart {
        public InfPart(String form, int index) {
            super(form, index);
        }

        @Override
        public IInfMWEDesc getParent() {
            return (IInfMWEDesc)super.getParent();
        }
    }
}

