/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.data;

import edu.mit.jmwe.data.IInfMWEDesc;
import edu.mit.jmwe.data.IMWEDesc;
import edu.mit.jmwe.data.IRootMWEDesc;
import edu.mit.jmwe.data.IToken;
import edu.mit.jmwe.data.StopWords;
import edu.mit.jmwe.data.Token;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMWEDesc<P extends IMWEDesc.IPart>
implements IMWEDesc {
    private final String form;
    private final List<P> parts;
    protected final int[] counts;

    public AbstractMWEDesc(String surfaceForm) {
        this(AbstractMWEDesc.splitOnUnderscores(surfaceForm), null);
    }

    public AbstractMWEDesc(String surfaceForm, int ... counts) {
        this(AbstractMWEDesc.splitOnUnderscores(surfaceForm), counts);
    }

    public AbstractMWEDesc(List<String> parts) {
        this(parts, null);
    }

    public AbstractMWEDesc(List<String> parts, int ... counts) {
        if (parts == null) {
            throw new NullPointerException();
        }
        if (counts != null) {
            for (int count : counts) {
                AbstractMWEDesc.checkCount(count);
            }
        }
        StringBuilder form = new StringBuilder();
        ArrayList<P> hidden = new ArrayList<P>(parts.size());
        ListIterator<String> i = parts.listIterator();
        while (i.hasNext()) {
            String part = Token.checkString(i.next()).toLowerCase();
            if (part.indexOf(95) != -1) {
                throw new IllegalArgumentException();
            }
            form.append(part);
            if (i.hasNext()) {
                form.append('_');
            }
            hidden.add(this.makePart(part, i.previousIndex()));
        }
        int countNum = counts == null ? this.getExpectedCountLength() : Math.max(counts.length, this.getExpectedCountLength());
        int[] hiddenCounts = new int[countNum];
        if (counts != null) {
            System.arraycopy(counts, 0, hiddenCounts, 0, counts.length);
        }
        this.form = form.toString();
        this.parts = Collections.unmodifiableList(hidden);
        this.counts = hiddenCounts;
    }

    protected abstract int getExpectedCountLength();

    protected static int checkCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException();
        }
        return count;
    }

    protected abstract P makePart(String var1, int var2);

    @Override
    public String getForm() {
        return this.form;
    }

    @Override
    public int getMarkedContinuous() {
        return this.counts[0];
    }

    @Override
    public int getMarkedSplit() {
        return this.counts[1];
    }

    @Override
    public int getUnmarkedExact() {
        return this.counts[2];
    }

    @Override
    public int getUnmarkedPattern() {
        return this.counts[3];
    }

    public List<P> getParts() {
        return this.parts;
    }

    @Override
    public int[] getCounts() {
        int[] result = new int[this.counts.length];
        System.arraycopy(this.counts, 0, result, 0, this.counts.length);
        return result;
    }

    @Override
    public int compareTo(IMWEDesc id) {
        int cmp = this.form.compareTo(id.getForm());
        if (cmp != 0) {
            return cmp;
        }
        return this.getPOS().compareTo(id.getPOS());
    }

    public String toString() {
        return this.form + "_" + this.getPOS().getIdentifier();
    }

    protected boolean isStopWord(String text) {
        return StopWords.isStopWord(text);
    }

    public static boolean equalsRoots(IMWEDesc one, IMWEDesc two) {
        IRootMWEDesc oneRoot = AbstractMWEDesc.getRoot(one);
        IRootMWEDesc twoRoot = AbstractMWEDesc.getRoot(two);
        return oneRoot.getID().equals(twoRoot.getID());
    }

    public static IRootMWEDesc getRoot(IMWEDesc desc) {
        if (desc == null) {
            throw new NullPointerException();
        }
        if (desc instanceof IRootMWEDesc) {
            return (IRootMWEDesc)desc;
        }
        IInfMWEDesc infDesc = (IInfMWEDesc)desc;
        return infDesc.getRootMWEDesc();
    }

    public static List<String> splitOnUnderscores(String str) {
        str = str.trim();
        str = boundaryUnderscores.matcher(str).replaceAll("");
        String[] parts = underscores.split(str);
        return Collections.unmodifiableList(Arrays.asList(parts));
    }

    public static String concatenate(Iterable<String> parts, String separator) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> i = parts.iterator();
        while (i.hasNext()) {
            sb.append(i.next().toLowerCase());
            if (!i.hasNext()) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static boolean isFillerForSlot(IToken token, IMWEDesc.IPart part) {
        if (token == null) {
            throw new NullPointerException();
        }
        if (part == null) {
            throw new NullPointerException();
        }
        if (part.getForm().equalsIgnoreCase(token.getForm())) {
            return true;
        }
        if (part instanceof IRootMWEDesc.IRootPart && token.getStems() != null) {
            for (String stem : token.getStems()) {
                if (!part.getForm().equalsIgnoreCase(stem)) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract class AbstractPart
    implements IMWEDesc.IPart {
        private final String form;
        private final int index;
        private final boolean isStopWord;

        public AbstractPart(String form, int index) {
            if (index < 0) {
                throw new IllegalArgumentException();
            }
            form = Token.checkString(form);
            boolean isStopWord = AbstractMWEDesc.this.isStopWord(form);
            this.form = form;
            this.index = index;
            this.isStopWord = isStopWord;
        }

        public IMWEDesc getParent() {
            return AbstractMWEDesc.this;
        }

        public String getForm() {
            return this.form;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean isStopWord() {
            return this.isStopWord;
        }

        public String toString() {
            return this.form + ':' + Integer.toString(this.index);
        }

        public int compareTo(IMWEDesc.IPart o) {
            return this.index - o.getIndex();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + AbstractMWEDesc.this.hashCode();
            result = 31 * result + this.index;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AbstractPart other = (AbstractPart)obj;
            if (this.index != other.index) {
                return false;
            }
            return AbstractMWEDesc.this.equals(other.getParent());
        }
    }
}

